# Copyright 1999-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI="6"

inherit eutils java-utils-2 xdg-utils

DESCRIPTION="The decentralized bitcoin exchange (non-atomic, with arbitration)"
HOMEPAGE="https://bisq.network/ https://github.com/bisq-network/exchange/"

LICENSE="AGPL-3+"
SLOT="0"
KEYWORDS="~amd64"

# We use javapackager to bundle the java runtime, since java.security
# settings have to be overridden for bouncycastle.
# See: https://github.com/bisq-network/exchange/issues/907
BUNDLED_JAVA_RDEPEND="dev-libs/glib:2[abi_x86_64]
	dev-libs/libxslt[abi_x86_64]
	media-libs/fontconfig:1.0[abi_x86_64]
	x11-libs/gtk+:2[abi_x86_64]
	x11-libs/libXtst[abi_x86_64]
	x11-libs/pango[abi_x86_64]"
RDEPEND="!net-p2p/bisq-bin
	x11-misc/xdg-utils
	${BUNDLED_JAVA_RDEPEND}"
DEPEND="dev-java/maven-bin
	dev-java/oracle-jdk-bin:1.8[javafx,jce]"

SRC_URI="https://github.com/bisq-network/exchange/archive/v${PV}.tar.gz -> ${P}.tar.gz"

S="${WORKDIR}/exchange-${PV}"

# The jdk must have javafx and jce support
JAVA_PKG_WANT_BUILD_VM="oracle-jdk-bin-1.8"
JAVA_PKG_WANT_SOURCE=1.8
JAVA_PKG_WANT_TARGET=1.8

# Bundled java
QA_PREBUILT="opt/Bisq/Bisq opt/Bisq/libpackager.so opt/Bisq/runtime/*"
REQUIRES_EXCLUDE="libgstreamer-lite.so"

# Even though some of this stuff will not be used at runtime, it is all
# required in order to satisfy the maven build system.
EMAVEN_VENDOR=(
	"https://jitpack.io com/github/JesusMcCloud/jtorctl/0/jtorctl-0.jar"
	"https://jitpack.io com/github/JesusMcCloud/jtorctl/0/jtorctl-0.pom"
	"https://jitpack.io com/github/JesusMcCloud/netlayer/parent/b3497f1d/parent-b3497f1d.pom"
	"https://jitpack.io com/github/JesusMcCloud/netlayer/tor/b3497f1d/tor-b3497f1d.jar"
	"https://jitpack.io com/github/JesusMcCloud/netlayer/tor/b3497f1d/tor-b3497f1d.pom"
	"https://jitpack.io com/github/JesusMcCloud/netlayer/tor.native/b3497f1d/tor.native-b3497f1d.jar"
	"https://jitpack.io com/github/JesusMcCloud/netlayer/tor.native/b3497f1d/tor.native-b3497f1d.pom"
	"https://jitpack.io com/github/MicroUtils/kotlin-logging/3aedaa9310/kotlin-logging-3aedaa9310.jar"
	"https://jitpack.io com/github/MicroUtils/kotlin-logging/3aedaa9310/kotlin-logging-3aedaa9310.pom"
	"https://jitpack.io com/github/bisq-network/bitcoinj/bitcoinj-core/63c9a917/bitcoinj-core-63c9a917.jar"
	"https://jitpack.io com/github/bisq-network/bitcoinj/bitcoinj-core/63c9a917/bitcoinj-core-63c9a917.pom"
	"https://jitpack.io com/github/bisq-network/bitcoinj/bitcoinj-parent/63c9a917/bitcoinj-parent-63c9a917.pom"
	"https://jitpack.io com/github/bisq-network/btcd-cli4j/btcd-cli4j-core/29f99be/btcd-cli4j-core-29f99be.jar"
	"https://jitpack.io com/github/bisq-network/btcd-cli4j/btcd-cli4j-core/29f99be/btcd-cli4j-core-29f99be.pom"
	"https://jitpack.io com/github/bisq-network/btcd-cli4j/btcd-cli4j-daemon/29f99be/btcd-cli4j-daemon-29f99be.jar"
	"https://jitpack.io com/github/bisq-network/btcd-cli4j/btcd-cli4j-daemon/29f99be/btcd-cli4j-daemon-29f99be.pom"
	"https://jitpack.io com/github/bisq-network/btcd-cli4j/btcd-cli4j-parent/29f99be/btcd-cli4j-parent-29f99be.pom"
	"https://jitpack.io com/github/bisq-network/libdohj/libdohj-core/a83809f3/libdohj-core-a83809f3.jar"
	"https://jitpack.io com/github/bisq-network/libdohj/libdohj-core/a83809f3/libdohj-core-a83809f3.pom"
	"https://jitpack.io com/github/ravn/jsocks/567e1cd/jsocks-567e1cd.jar"
	"https://jitpack.io com/github/ravn/jsocks/567e1cd/jsocks-567e1cd.pom"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary/7.0.11/tor-binary-7.0.11.pom"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-geoip/7.0.11/tor-binary-geoip-7.0.11.jar"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-geoip/7.0.11/tor-binary-geoip-7.0.11.pom"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-linux32/7.0.11/tor-binary-linux32-7.0.11.jar"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-linux32/7.0.11/tor-binary-linux32-7.0.11.pom"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-linux64/7.0.11/tor-binary-linux64-7.0.11.jar"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-linux64/7.0.11/tor-binary-linux64-7.0.11.pom"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-macos/7.0.11/tor-binary-macos-7.0.11.jar"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-macos/7.0.11/tor-binary-macos-7.0.11.pom"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-windows/7.0.11/tor-binary-windows-7.0.11.jar"
	"https://raw.githubusercontent.com/JesusMcCloud/tor-binary/testrelease/release com/cedricwalter/tor-binary-windows/7.0.11/tor-binary-windows-7.0.11.pom"
	"https://repo.maven.apache.org/maven2 antlr/antlr/2.7.2/antlr-2.7.2.jar"
	"https://repo.maven.apache.org/maven2 antlr/antlr/2.7.2/antlr-2.7.2.pom"
	"https://repo.maven.apache.org/maven2 aopalliance/aopalliance/1.0/aopalliance-1.0.jar"
	"https://repo.maven.apache.org/maven2 aopalliance/aopalliance/1.0/aopalliance-1.0.pom"
	"https://repo.maven.apache.org/maven2 avalon-framework/avalon-framework/4.1.3/avalon-framework-4.1.3.pom"
	"https://repo.maven.apache.org/maven2 backport-util-concurrent/backport-util-concurrent/3.1/backport-util-concurrent-3.1.jar"
	"https://repo.maven.apache.org/maven2 backport-util-concurrent/backport-util-concurrent/3.1/backport-util-concurrent-3.1.pom"
	"https://repo.maven.apache.org/maven2 ch/qos/logback/logback-classic/1.1.10/logback-classic-1.1.10.jar"
	"https://repo.maven.apache.org/maven2 ch/qos/logback/logback-classic/1.1.10/logback-classic-1.1.10.pom"
	"https://repo.maven.apache.org/maven2 ch/qos/logback/logback-core/1.1.10/logback-core-1.1.10.jar"
	"https://repo.maven.apache.org/maven2 ch/qos/logback/logback-core/1.1.10/logback-core-1.1.10.pom"
	"https://repo.maven.apache.org/maven2 ch/qos/logback/logback-parent/1.1.10/logback-parent-1.1.10.pom"
	"https://repo.maven.apache.org/maven2 classworlds/classworlds/1.1/classworlds-1.1.jar"
	"https://repo.maven.apache.org/maven2 classworlds/classworlds/1.1/classworlds-1.1.pom"
	"https://repo.maven.apache.org/maven2 classworlds/classworlds/1.1-alpha-2/classworlds-1.1-alpha-2.jar"
	"https://repo.maven.apache.org/maven2 classworlds/classworlds/1.1-alpha-2/classworlds-1.1-alpha-2.pom"
	"https://repo.maven.apache.org/maven2 com/fasterxml/jackson/core/jackson-annotations/2.8.10/jackson-annotations-2.8.10.jar"
	"https://repo.maven.apache.org/maven2 com/fasterxml/jackson/core/jackson-annotations/2.8.10/jackson-annotations-2.8.10.pom"
	"https://repo.maven.apache.org/maven2 com/fasterxml/jackson/core/jackson-core/2.8.10/jackson-core-2.8.10.jar"
	"https://repo.maven.apache.org/maven2 com/fasterxml/jackson/core/jackson-core/2.8.10/jackson-core-2.8.10.pom"
	"https://repo.maven.apache.org/maven2 com/fasterxml/jackson/core/jackson-databind/2.8.10/jackson-databind-2.8.10.jar"
	"https://repo.maven.apache.org/maven2 com/fasterxml/jackson/core/jackson-databind/2.8.10/jackson-databind-2.8.10.pom"
	"https://repo.maven.apache.org/maven2 com/fasterxml/jackson/jackson-parent/2.8/jackson-parent-2.8.pom"
	"https://repo.maven.apache.org/maven2 com/fasterxml/oss-parent/27/oss-parent-27.pom"
	"https://repo.maven.apache.org/maven2 com/google/code/findbugs/jsr305/2.0.1/jsr305-2.0.1.jar"
	"https://repo.maven.apache.org/maven2 com/google/code/findbugs/jsr305/2.0.1/jsr305-2.0.1.pom"
	"https://repo.maven.apache.org/maven2 com/google/code/findbugs/jsr305/3.0.1/jsr305-3.0.1.jar"
	"https://repo.maven.apache.org/maven2 com/google/code/findbugs/jsr305/3.0.1/jsr305-3.0.1.pom"
	"https://repo.maven.apache.org/maven2 com/google/code/gson/gson/2.2.4/gson-2.2.4.jar"
	"https://repo.maven.apache.org/maven2 com/google/code/gson/gson/2.3.1/gson-2.3.1.jar"
	"https://repo.maven.apache.org/maven2 com/google/code/gson/gson/2.3.1/gson-2.3.1.pom"
	"https://repo.maven.apache.org/maven2 com/google/code/gson/gson/2.7/gson-2.7.jar"
	"https://repo.maven.apache.org/maven2 com/google/code/gson/gson/2.7/gson-2.7.pom"
	"https://repo.maven.apache.org/maven2 com/google/code/gson/gson-parent/2.7/gson-parent-2.7.pom"
	"https://repo.maven.apache.org/maven2 com/google/collections/google-collections/1.0/google-collections-1.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/collections/google-collections/1.0/google-collections-1.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/google/1/google-1.pom"
	"https://repo.maven.apache.org/maven2 com/google/google/5/google-5.pom"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava/18.0/guava-18.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava/18.0/guava-18.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava/19.0/guava-19.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava/19.0/guava-19.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava/20.0/guava-20.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava/20.0/guava-20.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava-parent/18.0/guava-parent-18.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava-parent/19.0/guava-parent-19.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/guava/guava-parent/20.0/guava-parent-20.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/inject/guice/3.0/guice-3.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/inject/guice/4.1.0/guice-4.1.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/inject/guice/4.1.0/guice-4.1.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/inject/guice-parent/4.1.0/guice-parent-4.1.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protobuf-java/3.2.0/protobuf-java-3.2.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protobuf-java/3.3.0/protobuf-java-3.3.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protobuf-java/3.3.0/protobuf-java-3.3.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protobuf-java-util/3.3.0/protobuf-java-util-3.3.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protobuf-java-util/3.3.0/protobuf-java-util-3.3.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protobuf-parent/3.3.0/protobuf-parent-3.3.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protoc/3.3.0/protoc-3.3.0-linux-x86_64.exe"
	"https://repo.maven.apache.org/maven2 com/google/protobuf/protoc/3.3.0/protoc-3.3.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/zxing/core/2.0/core-2.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/zxing/core/2.0/core-2.0.pom"
	"https://repo.maven.apache.org/maven2 com/google/zxing/javase/2.0/javase-2.0.jar"
	"https://repo.maven.apache.org/maven2 com/google/zxing/javase/2.0/javase-2.0.pom"
	"https://repo.maven.apache.org/maven2 com/googlecode/jcsv/jcsv/1.4.0/jcsv-1.4.0.jar"
	"https://repo.maven.apache.org/maven2 com/googlecode/jcsv/jcsv/1.4.0/jcsv-1.4.0.pom"
	"https://repo.maven.apache.org/maven2 com/googlecode/json-simple/json-simple/1.1.1/json-simple-1.1.1.jar"
	"https://repo.maven.apache.org/maven2 com/googlecode/json-simple/json-simple/1.1.1/json-simple-1.1.1.pom"
	"https://repo.maven.apache.org/maven2 com/lambdaworks/scrypt/1.4.0/scrypt-1.4.0.jar"
	"https://repo.maven.apache.org/maven2 com/lambdaworks/scrypt/1.4.0/scrypt-1.4.0.pom"
	"https://repo.maven.apache.org/maven2 com/madgag/spongycastle/core/1.51.0.0/core-1.51.0.0.jar"
	"https://repo.maven.apache.org/maven2 com/madgag/spongycastle/core/1.51.0.0/core-1.51.0.0.pom"
	"https://repo.maven.apache.org/maven2 com/sparkjava/spark-core/2.5.2/spark-core-2.5.2.jar"
	"https://repo.maven.apache.org/maven2 com/sparkjava/spark-core/2.5.2/spark-core-2.5.2.pom"
	"https://repo.maven.apache.org/maven2 com/squareup/okhttp/okhttp/2.2.0/okhttp-2.2.0.jar"
	"https://repo.maven.apache.org/maven2 com/squareup/okhttp/okhttp/2.7.2/okhttp-2.7.2.jar"
	"https://repo.maven.apache.org/maven2 com/squareup/okhttp/okhttp/2.7.2/okhttp-2.7.2.pom"
	"https://repo.maven.apache.org/maven2 com/squareup/okhttp/parent/2.7.2/parent-2.7.2.pom"
	"https://repo.maven.apache.org/maven2 com/squareup/okio/okio/1.2.0/okio-1.2.0.jar"
	"https://repo.maven.apache.org/maven2 com/squareup/okio/okio/1.6.0/okio-1.6.0.jar"
	"https://repo.maven.apache.org/maven2 com/squareup/okio/okio/1.6.0/okio-1.6.0.pom"
	"https://repo.maven.apache.org/maven2 com/squareup/okio/okio-parent/1.6.0/okio-parent-1.6.0.pom"
	"https://repo.maven.apache.org/maven2 commons-beanutils/commons-beanutils/1.6/commons-beanutils-1.6.pom"
	"https://repo.maven.apache.org/maven2 commons-beanutils/commons-beanutils/1.7.0/commons-beanutils-1.7.0.jar"
	"https://repo.maven.apache.org/maven2 commons-beanutils/commons-beanutils/1.7.0/commons-beanutils-1.7.0.pom"
	"https://repo.maven.apache.org/maven2 commons-chain/commons-chain/1.1/commons-chain-1.1.jar"
	"https://repo.maven.apache.org/maven2 commons-chain/commons-chain/1.1/commons-chain-1.1.pom"
	"https://repo.maven.apache.org/maven2 commons-cli/commons-cli/1.0/commons-cli-1.0.jar"
	"https://repo.maven.apache.org/maven2 commons-cli/commons-cli/1.0/commons-cli-1.0.pom"
	"https://repo.maven.apache.org/maven2 commons-cli/commons-cli/1.2/commons-cli-1.2.jar"
	"https://repo.maven.apache.org/maven2 commons-cli/commons-cli/1.2/commons-cli-1.2.pom"
	"https://repo.maven.apache.org/maven2 commons-codec/commons-codec/1.3/commons-codec-1.3.pom"
	"https://repo.maven.apache.org/maven2 commons-codec/commons-codec/1.6/commons-codec-1.6.jar"
	"https://repo.maven.apache.org/maven2 commons-codec/commons-codec/1.6/commons-codec-1.6.pom"
	"https://repo.maven.apache.org/maven2 commons-codec/commons-codec/1.9/commons-codec-1.9.jar"
	"https://repo.maven.apache.org/maven2 commons-codec/commons-codec/1.9/commons-codec-1.9.pom"
	"https://repo.maven.apache.org/maven2 commons-collections/commons-collections/2.0/commons-collections-2.0.pom"
	"https://repo.maven.apache.org/maven2 commons-collections/commons-collections/2.1/commons-collections-2.1.pom"
	"https://repo.maven.apache.org/maven2 commons-collections/commons-collections/3.1/commons-collections-3.1.pom"
	"https://repo.maven.apache.org/maven2 commons-collections/commons-collections/3.2/commons-collections-3.2.pom"
	"https://repo.maven.apache.org/maven2 commons-collections/commons-collections/3.2.1/commons-collections-3.2.1.pom"
	"https://repo.maven.apache.org/maven2 commons-collections/commons-collections/3.2.2/commons-collections-3.2.2.jar"
	"https://repo.maven.apache.org/maven2 commons-collections/commons-collections/3.2.2/commons-collections-3.2.2.pom"
	"https://repo.maven.apache.org/maven2 commons-digester/commons-digester/1.6/commons-digester-1.6.jar"
	"https://repo.maven.apache.org/maven2 commons-digester/commons-digester/1.6/commons-digester-1.6.pom"
	"https://repo.maven.apache.org/maven2 commons-digester/commons-digester/1.8/commons-digester-1.8.pom"
	"https://repo.maven.apache.org/maven2 commons-io/commons-io/2.2/commons-io-2.2.pom"
	"https://repo.maven.apache.org/maven2 commons-io/commons-io/2.4/commons-io-2.4.jar"
	"https://repo.maven.apache.org/maven2 commons-io/commons-io/2.4/commons-io-2.4.pom"
	"https://repo.maven.apache.org/maven2 commons-io/commons-io/2.5/commons-io-2.5.jar"
	"https://repo.maven.apache.org/maven2 commons-io/commons-io/2.5/commons-io-2.5.pom"
	"https://repo.maven.apache.org/maven2 commons-lang/commons-lang/2.1/commons-lang-2.1.jar"
	"https://repo.maven.apache.org/maven2 commons-lang/commons-lang/2.1/commons-lang-2.1.pom"
	"https://repo.maven.apache.org/maven2 commons-lang/commons-lang/2.3/commons-lang-2.3.jar"
	"https://repo.maven.apache.org/maven2 commons-lang/commons-lang/2.3/commons-lang-2.3.pom"
	"https://repo.maven.apache.org/maven2 commons-lang/commons-lang/2.4/commons-lang-2.4.pom"
	"https://repo.maven.apache.org/maven2 commons-lang/commons-lang/2.6/commons-lang-2.6.jar"
	"https://repo.maven.apache.org/maven2 commons-lang/commons-lang/2.6/commons-lang-2.6.pom"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.0/commons-logging-1.0.pom"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.0.3/commons-logging-1.0.3.pom"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.0.4/commons-logging-1.0.4.jar"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.0.4/commons-logging-1.0.4.pom"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.1/commons-logging-1.1.pom"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.1.1/commons-logging-1.1.1.pom"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.1.3/commons-logging-1.1.3.jar"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.2/commons-logging-1.2.jar"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging/1.2/commons-logging-1.2.pom"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging-api/1.1/commons-logging-api-1.1.jar"
	"https://repo.maven.apache.org/maven2 commons-logging/commons-logging-api/1.1/commons-logging-api-1.1.pom"
	"https://repo.maven.apache.org/maven2 commons-validator/commons-validator/1.3.1/commons-validator-1.3.1.jar"
	"https://repo.maven.apache.org/maven2 commons-validator/commons-validator/1.3.1/commons-validator-1.3.1.pom"
	"https://repo.maven.apache.org/maven2 de/jensd/fontawesomefx/8.0.0/fontawesomefx-8.0.0.jar"
	"https://repo.maven.apache.org/maven2 de/jensd/fontawesomefx/8.0.0/fontawesomefx-8.0.0.pom"
	"https://repo.maven.apache.org/maven2 dom4j/dom4j/1.1/dom4j-1.1.jar"
	"https://repo.maven.apache.org/maven2 dom4j/dom4j/1.1/dom4j-1.1.pom"
	"https://repo.maven.apache.org/maven2 javax/inject/javax.inject/1/javax.inject-1.jar"
	"https://repo.maven.apache.org/maven2 javax/inject/javax.inject/1/javax.inject-1.pom"
	"https://repo.maven.apache.org/maven2 javax/servlet/javax.servlet-api/3.1.0/javax.servlet-api-3.1.0.jar"
	"https://repo.maven.apache.org/maven2 javax/servlet/javax.servlet-api/3.1.0/javax.servlet-api-3.1.0.pom"
	"https://repo.maven.apache.org/maven2 javax/servlet/servlet-api/2.3/servlet-api-2.3.pom"
	"https://repo.maven.apache.org/maven2 junit/junit/3.8.1/junit-3.8.1.jar"
	"https://repo.maven.apache.org/maven2 junit/junit/3.8.1/junit-3.8.1.pom"
	"https://repo.maven.apache.org/maven2 junit/junit/3.8.2/junit-3.8.2.jar"
	"https://repo.maven.apache.org/maven2 junit/junit/3.8.2/junit-3.8.2.pom"
	"https://repo.maven.apache.org/maven2 junit/junit/4.11/junit-4.11.jar"
	"https://repo.maven.apache.org/maven2 junit/junit/4.11/junit-4.11.pom"
	"https://repo.maven.apache.org/maven2 log4j/log4j/1.2.12/log4j-1.2.12.jar"
	"https://repo.maven.apache.org/maven2 log4j/log4j/1.2.12/log4j-1.2.12.pom"
	"https://repo.maven.apache.org/maven2 logkit/logkit/1.0.1/logkit-1.0.1.pom"
	"https://repo.maven.apache.org/maven2 net/bytebuddy/byte-buddy/1.6.5/byte-buddy-1.6.5.jar"
	"https://repo.maven.apache.org/maven2 net/bytebuddy/byte-buddy/1.6.5/byte-buddy-1.6.5.pom"
	"https://repo.maven.apache.org/maven2 net/bytebuddy/byte-buddy-agent/1.6.5/byte-buddy-agent-1.6.5.jar"
	"https://repo.maven.apache.org/maven2 net/bytebuddy/byte-buddy-agent/1.6.5/byte-buddy-agent-1.6.5.pom"
	"https://repo.maven.apache.org/maven2 net/bytebuddy/byte-buddy-parent/1.6.5/byte-buddy-parent-1.6.5.pom"
	"https://repo.maven.apache.org/maven2 net/glxn/qrgen/1.3/qrgen-1.3.jar"
	"https://repo.maven.apache.org/maven2 net/glxn/qrgen/1.3/qrgen-1.3.pom"
	"https://repo.maven.apache.org/maven2 net/gpedro/integrations/slack/slack-webhook/1.1.1/slack-webhook-1.1.1.jar"
	"https://repo.maven.apache.org/maven2 net/gpedro/integrations/slack/slack-webhook/1.1.1/slack-webhook-1.1.1.pom"
	"https://repo.maven.apache.org/maven2 net/java/jvnet-parent/3/jvnet-parent-3.pom"
	"https://repo.maven.apache.org/maven2 net/jcip/jcip-annotations/1.0/jcip-annotations-1.0.jar"
	"https://repo.maven.apache.org/maven2 net/jcip/jcip-annotations/1.0/jcip-annotations-1.0.pom"
	"https://repo.maven.apache.org/maven2 net/sf/jopt-simple/jopt-simple/4.8/jopt-simple-4.8.jar"
	"https://repo.maven.apache.org/maven2 net/sf/jopt-simple/jopt-simple/5.0.3/jopt-simple-5.0.3.jar"
	"https://repo.maven.apache.org/maven2 net/sf/jopt-simple/jopt-simple/5.0.3/jopt-simple-5.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/ant/ant/1.9.4/ant-1.9.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/ant/ant/1.9.4/ant-1.9.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/ant/ant-launcher/1.9.4/ant-launcher-1.9.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/ant/ant-launcher/1.9.4/ant-launcher-1.9.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/ant/ant-parent/1.9.4/ant-parent-1.9.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/10/apache-10.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/11/apache-11.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/13/apache-13.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/14/apache-14.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/16/apache-16.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/18/apache-18.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/2/apache-2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/3/apache-3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/4/apache-4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/5/apache-5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/6/apache-6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/7/apache-7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/apache/9/apache-9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-compress/1.11/commons-compress-1.11.jar"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-compress/1.11/commons-compress-1.11.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-compress/1.15/commons-compress-1.15.jar"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-compress/1.15/commons-compress-1.15.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-lang3/3.1/commons-lang3-3.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-lang3/3.1/commons-lang3-3.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-lang3/3.4/commons-lang3-3.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-lang3/3.4/commons-lang3-3.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/11/commons-parent-11.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/17/commons-parent-17.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/22/commons-parent-22.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/24/commons-parent-24.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/25/commons-parent-25.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/32/commons-parent-32.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/34/commons-parent-34.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/37/commons-parent-37.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/39/commons-parent-39.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/42/commons-parent-42.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/5/commons-parent-5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/commons/commons-parent/9/commons-parent-9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpclient/4.0.2/httpclient-4.0.2.jar"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpclient/4.0.2/httpclient-4.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpclient/4.5/httpclient-4.5.jar"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpclient/4.5.3/httpclient-4.5.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpclient/4.5.3/httpclient-4.5.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcomponents-client/4.0.2/httpcomponents-client-4.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcomponents-client/4.5.3/httpcomponents-client-4.5.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcomponents-core/4.0.1/httpcomponents-core-4.0.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcomponents-core/4.4.6/httpcomponents-core-4.4.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcore/4.0.1/httpcore-4.0.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcore/4.0.1/httpcore-4.0.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcore/4.4.1/httpcore-4.4.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcore/4.4.6/httpcore-4.4.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/httpcore/4.4.6/httpcore-4.4.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/project/4.0/project-4.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/project/4.1/project-4.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/httpcomponents/project/7/project-7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia/1.0/doxia-1.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia/1.0-alpha-7/doxia-1.0-alpha-7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia/1.1/doxia-1.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia/1.2/doxia-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia/1.4/doxia-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-core/1.2/doxia-core-1.2.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-core/1.2/doxia-core-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-core/1.4/doxia-core-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-decoration-model/1.2/doxia-decoration-model-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-decoration-model/1.4/doxia-decoration-model-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-decoration-model/1.4/doxia-decoration-model-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-logging-api/1.1/doxia-logging-api-1.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-logging-api/1.1/doxia-logging-api-1.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-logging-api/1.2/doxia-logging-api-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-logging-api/1.4/doxia-logging-api-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-logging-api/1.4/doxia-logging-api-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-module-fml/1.2/doxia-module-fml-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-module-fml/1.4/doxia-module-fml-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-module-fml/1.4/doxia-module-fml-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-module-xhtml/1.2/doxia-module-xhtml-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-module-xhtml/1.4/doxia-module-xhtml-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-module-xhtml/1.4/doxia-module-xhtml-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-modules/1.2/doxia-modules-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-modules/1.4/doxia-modules-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.0/doxia-sink-api-1.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.0-alpha-7/doxia-sink-api-1.0-alpha-7.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.0-alpha-7/doxia-sink-api-1.0-alpha-7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.1/doxia-sink-api-1.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.1/doxia-sink-api-1.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.2/doxia-sink-api-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.4/doxia-sink-api-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sink-api/1.4/doxia-sink-api-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-site-renderer/1.2/doxia-site-renderer-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-site-renderer/1.4/doxia-site-renderer-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-site-renderer/1.4/doxia-site-renderer-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sitetools/1.2/doxia-sitetools-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/doxia/doxia-sitetools/1.4/doxia-sitetools-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/enforcer/enforcer/1.4.1/enforcer-1.4.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/enforcer/enforcer-api/1.4.1/enforcer-api-1.4.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/enforcer/enforcer-api/1.4.1/enforcer-api-1.4.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/enforcer/enforcer-rules/1.4.1/enforcer-rules-1.4.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/enforcer/enforcer-rules/1.4.1/enforcer-rules-1.4.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/2.0.2/maven-2.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/2.0.5/maven-2.0.5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/2.0.6/maven-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/2.0.8/maven-2.0.8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/2.0.9/maven-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/2.2.1/maven-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/3.0/maven-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven/3.0.3/maven-3.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-aether-provider/3.0/maven-aether-provider-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-aether-provider/3.0/maven-aether-provider-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-archiver/2.5/maven-archiver-2.5.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-archiver/2.5/maven-archiver-2.5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.0.2/maven-artifact-2.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.0.5/maven-artifact-2.0.5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.0.6/maven-artifact-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.0.6/maven-artifact-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.0.9/maven-artifact-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.0.9/maven-artifact-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.2.1/maven-artifact-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/2.2.1/maven-artifact-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/3.0/maven-artifact-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact/3.0/maven-artifact-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact-manager/2.0.6/maven-artifact-manager-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact-manager/2.0.6/maven-artifact-manager-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact-manager/2.0.9/maven-artifact-manager-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact-manager/2.0.9/maven-artifact-manager-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact-manager/2.2.1/maven-artifact-manager-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-artifact-manager/2.2.1/maven-artifact-manager-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-compat/3.0/maven-compat-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-compat/3.0/maven-compat-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-compat/3.0.3/maven-compat-3.0.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-compat/3.0.3/maven-compat-3.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/2.0.6/maven-core-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/2.0.6/maven-core-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/2.0.9/maven-core-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/2.0.9/maven-core-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/2.2.1/maven-core-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/2.2.1/maven-core-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/3.0/maven-core-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-core/3.0/maven-core-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-error-diagnostics/2.0.6/maven-error-diagnostics-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-error-diagnostics/2.0.6/maven-error-diagnostics-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-error-diagnostics/2.0.9/maven-error-diagnostics-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-error-diagnostics/2.0.9/maven-error-diagnostics-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-error-diagnostics/2.2.1/maven-error-diagnostics-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-error-diagnostics/2.2.1/maven-error-diagnostics-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.0.5/maven-model-2.0.5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.0.6/maven-model-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.0.6/maven-model-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.0.8/maven-model-2.0.8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.0.9/maven-model-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.0.9/maven-model-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.2.1/maven-model-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/2.2.1/maven-model-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/3.0/maven-model-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/3.0/maven-model-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/3.0.3/maven-model-3.0.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model/3.0.3/maven-model-3.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model-builder/3.0/maven-model-builder-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model-builder/3.0/maven-model-builder-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model-builder/3.0.3/maven-model-builder-3.0.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-model-builder/3.0.3/maven-model-builder-3.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-monitor/2.0.6/maven-monitor-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-monitor/2.0.6/maven-monitor-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-monitor/2.0.9/maven-monitor-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-monitor/2.0.9/maven-monitor-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-monitor/2.2.1/maven-monitor-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-monitor/2.2.1/maven-monitor-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/10/maven-parent-10.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/11/maven-parent-11.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/13/maven-parent-13.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/15/maven-parent-15.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/16/maven-parent-16.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/19/maven-parent-19.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/21/maven-parent-21.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/22/maven-parent-22.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/23/maven-parent-23.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/24/maven-parent-24.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/26/maven-parent-26.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/30/maven-parent-30.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/5/maven-parent-5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/6/maven-parent-6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/7/maven-parent-7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/8/maven-parent-8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-parent/9/maven-parent-9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/2.0.6/maven-plugin-api-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/2.0.6/maven-plugin-api-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/2.0.9/maven-plugin-api-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/2.0.9/maven-plugin-api-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/2.2.1/maven-plugin-api-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/2.2.1/maven-plugin-api-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/3.0/maven-plugin-api-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-api/3.0/maven-plugin-api-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-descriptor/2.0.6/maven-plugin-descriptor-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-descriptor/2.0.6/maven-plugin-descriptor-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-descriptor/2.0.9/maven-plugin-descriptor-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-descriptor/2.0.9/maven-plugin-descriptor-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-descriptor/2.2.1/maven-plugin-descriptor-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-descriptor/2.2.1/maven-plugin-descriptor-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-parameter-documenter/2.0.6/maven-plugin-parameter-documenter-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-parameter-documenter/2.0.6/maven-plugin-parameter-documenter-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-parameter-documenter/2.0.9/maven-plugin-parameter-documenter-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-parameter-documenter/2.0.9/maven-plugin-parameter-documenter-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-parameter-documenter/2.2.1/maven-plugin-parameter-documenter-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-parameter-documenter/2.2.1/maven-plugin-parameter-documenter-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-registry/2.0.6/maven-plugin-registry-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-registry/2.0.6/maven-plugin-registry-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-registry/2.0.9/maven-plugin-registry-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-registry/2.0.9/maven-plugin-registry-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-registry/2.2.1/maven-plugin-registry-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-plugin-registry/2.2.1/maven-plugin-registry-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-profile/2.0.6/maven-profile-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-profile/2.0.6/maven-profile-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-profile/2.0.9/maven-profile-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-profile/2.0.9/maven-profile-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-profile/2.2.1/maven-profile-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-profile/2.2.1/maven-profile-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-project/2.0.6/maven-project-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-project/2.0.6/maven-project-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-project/2.0.9/maven-project-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-project/2.0.9/maven-project-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-project/2.2.1/maven-project-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-project/2.2.1/maven-project-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/2.0.6/maven-repository-metadata-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/2.0.6/maven-repository-metadata-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/2.0.9/maven-repository-metadata-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/2.0.9/maven-repository-metadata-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/2.2.1/maven-repository-metadata-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/2.2.1/maven-repository-metadata-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/3.0/maven-repository-metadata-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-repository-metadata/3.0/maven-repository-metadata-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/2.0.6/maven-settings-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/2.0.6/maven-settings-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/2.0.9/maven-settings-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/2.0.9/maven-settings-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/2.2.1/maven-settings-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/2.2.1/maven-settings-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/3.0/maven-settings-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/3.0/maven-settings-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings/3.0.3/maven-settings-3.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings-builder/3.0/maven-settings-builder-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-settings-builder/3.0/maven-settings-builder-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-toolchain/1.0/maven-toolchain-1.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-toolchain/1.0/maven-toolchain-1.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-toolchain/2.0.9/maven-toolchain-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/maven-toolchain/2.0.9/maven-toolchain-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-testing/maven-plugin-testing/1.3/maven-plugin-testing-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-testing/maven-plugin-testing-harness/1.3/maven-plugin-testing-harness-1.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-testing/maven-plugin-testing-harness/1.3/maven-plugin-testing-harness-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-tools/maven-plugin-annotations/3.1/maven-plugin-annotations-3.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-tools/maven-plugin-annotations/3.1/maven-plugin-annotations-3.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-tools/maven-plugin-annotations/3.4/maven-plugin-annotations-3.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-tools/maven-plugin-annotations/3.4/maven-plugin-annotations-3.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-tools/maven-plugin-tools/3.1/maven-plugin-tools-3.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugin-tools/maven-plugin-tools/3.4/maven-plugin-tools-3.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-antrun-plugin/1.8/maven-antrun-plugin-1.8.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-antrun-plugin/1.8/maven-antrun-plugin-1.8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-clean-plugin/2.5/maven-clean-plugin-2.5.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-compiler-plugin/3.1/maven-compiler-plugin-3.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-compiler-plugin/3.1/maven-compiler-plugin-3.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-dependency-plugin/3.0.1/maven-dependency-plugin-3.0.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-dependency-plugin/3.0.1/maven-dependency-plugin-3.0.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-deploy-plugin/2.7/maven-deploy-plugin-2.7.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-enforcer-plugin/1.4.1/maven-enforcer-plugin-1.4.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-enforcer-plugin/1.4.1/maven-enforcer-plugin-1.4.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-install-plugin/2.4/maven-install-plugin-2.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-jar-plugin/2.4/maven-jar-plugin-2.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-jar-plugin/2.4/maven-jar-plugin-2.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-plugins/22/maven-plugins-22.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-plugins/23/maven-plugins-23.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-plugins/24/maven-plugins-24.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-plugins/27/maven-plugins-27.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-plugins/30/maven-plugins-30.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-resources-plugin/2.6/maven-resources-plugin-2.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-resources-plugin/2.6/maven-resources-plugin-2.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-shade-plugin/2.3/maven-shade-plugin-2.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-shade-plugin/3.1.0/maven-shade-plugin-3.1.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-shade-plugin/3.1.0/maven-shade-plugin-3.1.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-site-plugin/3.3/maven-site-plugin-3.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-surefire-plugin/2.12.4/maven-surefire-plugin-2.12.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/plugins/maven-surefire-plugin/2.12.4/maven-surefire-plugin-2.12.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting/2.0.6/maven-reporting-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting/2.0.9/maven-reporting-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting/2.2.1/maven-reporting-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/2.0.6/maven-reporting-api-2.0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/2.0.6/maven-reporting-api-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/2.0.9/maven-reporting-api-2.0.9.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/2.0.9/maven-reporting-api-2.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/2.2.1/maven-reporting-api-2.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/2.2.1/maven-reporting-api-2.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/3.0/maven-reporting-api-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-api/3.0/maven-reporting-api-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-impl/2.3/maven-reporting-impl-2.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/reporting/maven-reporting-impl/2.3/maven-reporting-impl-2.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/file-management/1.2.1/file-management-1.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/file-management/1.2.1/file-management-1.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-artifact-transfer/0.9.1/maven-artifact-transfer-0.9.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-artifact-transfer/0.9.1/maven-artifact-transfer-0.9.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-common-artifact-filters/1.3/maven-common-artifact-filters-1.3.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-common-artifact-filters/1.3/maven-common-artifact-filters-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-common-artifact-filters/1.4/maven-common-artifact-filters-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-common-artifact-filters/1.4/maven-common-artifact-filters-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-common-artifact-filters/3.0.1/maven-common-artifact-filters-3.0.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-common-artifact-filters/3.0.1/maven-common-artifact-filters-3.0.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-dependency-analyzer/1.7/maven-dependency-analyzer-1.7.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-dependency-analyzer/1.7/maven-dependency-analyzer-1.7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-dependency-tree/2.2/maven-dependency-tree-2.2.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-dependency-tree/2.2/maven-dependency-tree-2.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-dependency-tree/3.0.1/maven-dependency-tree-3.0.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-dependency-tree/3.0.1/maven-dependency-tree-3.0.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-filtering/1.1/maven-filtering-1.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-filtering/1.1/maven-filtering-1.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/10/maven-shared-components-10.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/12/maven-shared-components-12.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/15/maven-shared-components-15.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/17/maven-shared-components-17.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/18/maven-shared-components-18.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/19/maven-shared-components-19.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/20/maven-shared-components-20.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/30/maven-shared-components-30.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-components/8/maven-shared-components-8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-incremental/1.1/maven-shared-incremental-1.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-incremental/1.1/maven-shared-incremental-1.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-io/1.1/maven-shared-io-1.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-io/1.1/maven-shared-io-1.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-utils/0.1/maven-shared-utils-0.1.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-utils/0.1/maven-shared-utils-0.1.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-utils/0.6/maven-shared-utils-0.6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-utils/0.6/maven-shared-utils-0.6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-utils/3.1.0/maven-shared-utils-3.1.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/shared/maven-shared-utils/3.1.0/maven-shared-utils-3.1.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/surefire/maven-surefire-common/2.12.4/maven-surefire-common-2.12.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/surefire/maven-surefire-common/2.12.4/maven-surefire-common-2.12.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/surefire/surefire/2.12.4/surefire-2.12.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/surefire/surefire-api/2.12.4/surefire-api-2.12.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/surefire/surefire-api/2.12.4/surefire-api-2.12.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/surefire/surefire-booter/2.12.4/surefire-booter-2.12.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/surefire/surefire-booter/2.12.4/surefire-booter-2.12.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon/1.0-alpha-6/wagon-1.0-alpha-6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon/1.0-beta-6/wagon-1.0-beta-6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon/1.0-beta-7/wagon-1.0-beta-7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon-provider-api/1.0-alpha-6/wagon-provider-api-1.0-alpha-6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon-provider-api/1.0-alpha-6/wagon-provider-api-1.0-alpha-6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon-provider-api/1.0-beta-6/wagon-provider-api-1.0-beta-6.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon-provider-api/1.0-beta-6/wagon-provider-api-1.0-beta-6.pom"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon-provider-api/1.0-beta-7/wagon-provider-api-1.0-beta-7.jar"
	"https://repo.maven.apache.org/maven2 org/apache/maven/wagon/wagon-provider-api/1.0-beta-7/wagon-provider-api-1.0-beta-7.pom"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-core/1.3.8/struts-core-1.3.8.jar"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-core/1.3.8/struts-core-1.3.8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-master/4/struts-master-4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-parent/1.3.8/struts-parent-1.3.8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-taglib/1.3.8/struts-taglib-1.3.8.jar"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-taglib/1.3.8/struts-taglib-1.3.8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-tiles/1.3.8/struts-tiles-1.3.8.jar"
	"https://repo.maven.apache.org/maven2 org/apache/struts/struts-tiles/1.3.8/struts-tiles-1.3.8.pom"
	"https://repo.maven.apache.org/maven2 org/apache/velocity/velocity/1.5/velocity-1.5.jar"
	"https://repo.maven.apache.org/maven2 org/apache/velocity/velocity/1.5/velocity-1.5.pom"
	"https://repo.maven.apache.org/maven2 org/apache/velocity/velocity/1.6.2/velocity-1.6.2.pom"
	"https://repo.maven.apache.org/maven2 org/apache/velocity/velocity-tools/2.0/velocity-tools-2.0.jar"
	"https://repo.maven.apache.org/maven2 org/apache/velocity/velocity-tools/2.0/velocity-tools-2.0.pom"
	"https://repo.maven.apache.org/maven2 org/apache/xbean/xbean/3.4/xbean-3.4.pom"
	"https://repo.maven.apache.org/maven2 org/apache/xbean/xbean-reflect/3.4/xbean-reflect-3.4.jar"
	"https://repo.maven.apache.org/maven2 org/apache/xbean/xbean-reflect/3.4/xbean-reflect-3.4.pom"
	"https://repo.maven.apache.org/maven2 org/beanshell/beanshell/2.0b4/beanshell-2.0b4.pom"
	"https://repo.maven.apache.org/maven2 org/beanshell/bsh/2.0b4/bsh-2.0b4.jar"
	"https://repo.maven.apache.org/maven2 org/beanshell/bsh/2.0b4/bsh-2.0b4.pom"
	"https://repo.maven.apache.org/maven2 org/bitcoinj/bitcoinj-parent/0.14.1/bitcoinj-parent-0.14.1.pom"
	"https://repo.maven.apache.org/maven2 org/bitcoinj/orchid/1.1.1/orchid-1.1.1.jar"
	"https://repo.maven.apache.org/maven2 org/bitcoinj/orchid/1.2.1/orchid-1.2.1.jar"
	"https://repo.maven.apache.org/maven2 org/bitcoinj/orchid/1.2.1/orchid-1.2.1.pom"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcpg-jdk15on/1.56/bcpg-jdk15on-1.56.jar"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcpg-jdk15on/1.56/bcpg-jdk15on-1.56.pom"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcpg-jdk16/1.46/bcpg-jdk16-1.46.jar"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcpg-jdk16/1.46/bcpg-jdk16-1.46.pom"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcprov-jdk15on/1.56/bcprov-jdk15on-1.56.jar"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcprov-jdk15on/1.56/bcprov-jdk15on-1.56.pom"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcprov-jdk16/1.46/bcprov-jdk16-1.46.jar"
	"https://repo.maven.apache.org/maven2 org/bouncycastle/bcprov-jdk16/1.46/bcprov-jdk16-1.46.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/1.0.10/plexus-1.0.10.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/1.0.11/plexus-1.0.11.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/1.0.12/plexus-1.0.12.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/1.0.4/plexus-1.0.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/1.0.8/plexus-1.0.8.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/1.0.9/plexus-1.0.9.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/2.0.2/plexus-2.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/2.0.3/plexus-2.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/2.0.6/plexus-2.0.6.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/2.0.7/plexus-2.0.7.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/3.0.1/plexus-3.0.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/3.1/plexus-3.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/3.2/plexus-3.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/3.3/plexus-3.3.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/3.3.1/plexus-3.3.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/3.3.2/plexus-3.3.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus/4.0/plexus-4.0.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-archiver/2.1/plexus-archiver-2.1.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-archiver/2.1/plexus-archiver-2.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-archiver/2.2/plexus-archiver-2.2.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-archiver/2.2/plexus-archiver-2.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-archiver/3.4/plexus-archiver-3.4.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-archiver/3.4/plexus-archiver-3.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/1.2-alpha-7/plexus-classworlds-1.2-alpha-7.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/1.2-alpha-9/plexus-classworlds-1.2-alpha-9.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/2.2.2/plexus-classworlds-2.2.2.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/2.2.2/plexus-classworlds-2.2.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/2.2.3/plexus-classworlds-2.2.3.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/2.2.3/plexus-classworlds-2.2.3.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/2.4/plexus-classworlds-2.4.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-classworlds/2.4/plexus-classworlds-2.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compiler/2.2/plexus-compiler-2.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compiler-api/2.2/plexus-compiler-api-2.2.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compiler-api/2.2/plexus-compiler-api-2.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compiler-javac/2.2/plexus-compiler-javac-2.2.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compiler-javac/2.2/plexus-compiler-javac-2.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compiler-manager/2.2/plexus-compiler-manager-2.2.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compiler-manager/2.2/plexus-compiler-manager-2.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-compilers/2.2/plexus-compilers-2.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-component-annotations/1.5.5/plexus-component-annotations-1.5.5.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-component-annotations/1.5.5/plexus-component-annotations-1.5.5.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-component-annotations/1.6/plexus-component-annotations-1.6.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-component-annotations/1.6/plexus-component-annotations-1.6.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.1.12/plexus-components-1.1.12.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.1.14/plexus-components-1.1.14.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.1.15/plexus-components-1.1.15.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.1.18/plexus-components-1.1.18.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.1.19/plexus-components-1.1.19.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.1.20/plexus-components-1.1.20.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.1.4/plexus-components-1.1.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.2/plexus-components-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-components/1.3.1/plexus-components-1.3.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.0-alpha-20/plexus-container-default-1.0-alpha-20.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.0-alpha-30/plexus-container-default-1.0-alpha-30.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.0-alpha-30/plexus-container-default-1.0-alpha-30.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.0-alpha-8/plexus-container-default-1.0-alpha-8.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.0-alpha-9/plexus-container-default-1.0-alpha-9.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.0-alpha-9-stable-1/plexus-container-default-1.0-alpha-9-stable-1.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.0-alpha-9-stable-1/plexus-container-default-1.0-alpha-9-stable-1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.5.5/plexus-container-default-1.5.5.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-container-default/1.5.5/plexus-container-default-1.5.5.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-containers/1.0-alpha-20/plexus-containers-1.0-alpha-20.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-containers/1.0-alpha-30/plexus-containers-1.0-alpha-30.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-containers/1.0.3/plexus-containers-1.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-containers/1.5.5/plexus-containers-1.5.5.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-containers/1.6/plexus-containers-1.6.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-i18n/1.0-beta-6/plexus-i18n-1.0-beta-6.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-i18n/1.0-beta-6/plexus-i18n-1.0-beta-6.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-i18n/1.0-beta-7/plexus-i18n-1.0-beta-7.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-i18n/1.0-beta-7/plexus-i18n-1.0-beta-7.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interactivity-api/1.0-alpha-4/plexus-interactivity-api-1.0-alpha-4.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interactivity-api/1.0-alpha-4/plexus-interactivity-api-1.0-alpha-4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.11/plexus-interpolation-1.11.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.11/plexus-interpolation-1.11.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.12/plexus-interpolation-1.12.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.13/plexus-interpolation-1.13.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.13/plexus-interpolation-1.13.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.14/plexus-interpolation-1.14.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.14/plexus-interpolation-1.14.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.15/plexus-interpolation-1.15.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-interpolation/1.15/plexus-interpolation-1.15.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-io/2.0.2/plexus-io-2.0.2.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-io/2.0.2/plexus-io-2.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-io/2.0.4/plexus-io-2.0.4.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-io/2.0.4/plexus-io-2.0.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-io/2.4/plexus-io-2.4.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-io/2.4/plexus-io-2.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-io/2.7.1/plexus-io-2.7.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.0.4/plexus-utils-1.0.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.1/plexus-utils-1.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.3/plexus-utils-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.4.1/plexus-utils-1.4.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.4.5/plexus-utils-1.4.5.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.4.6/plexus-utils-1.4.6.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.5.1/plexus-utils-1.5.1.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.5.1/plexus-utils-1.5.1.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.5.15/plexus-utils-1.5.15.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.5.5/plexus-utils-1.5.5.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.5.6/plexus-utils-1.5.6.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/1.5.8/plexus-utils-1.5.8.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/2.0.4/plexus-utils-2.0.4.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/2.0.5/plexus-utils-2.0.5.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/2.0.5/plexus-utils-2.0.5.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0/plexus-utils-3.0.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0/plexus-utils-3.0.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.10/plexus-utils-3.0.10.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.20/plexus-utils-3.0.20.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.20/plexus-utils-3.0.20.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.22/plexus-utils-3.0.22.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.22/plexus-utils-3.0.22.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.24/plexus-utils-3.0.24.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.24/plexus-utils-3.0.24.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.8/plexus-utils-3.0.8.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-utils/3.0.8/plexus-utils-3.0.8.pom"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-velocity/1.1.7/plexus-velocity-1.1.7.jar"
	"https://repo.maven.apache.org/maven2 org/codehaus/plexus/plexus-velocity/1.1.7/plexus-velocity-1.1.7.pom"
	"https://repo.maven.apache.org/maven2 org/controlsfx/controlsfx/8.0.6_20/controlsfx-8.0.6_20.jar"
	"https://repo.maven.apache.org/maven2 org/controlsfx/controlsfx/8.0.6_20/controlsfx-8.0.6_20.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/aether/aether/0.9.0.M2/aether-0.9.0.M2.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/aether/aether-util/0.9.0.M2/aether-util-0.9.0.M2.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/aether/aether-util/0.9.0.M2/aether-util-0.9.0.M2.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-http/9.3.6.v20151106/jetty-http-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-http/9.3.6.v20151106/jetty-http-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-io/9.3.6.v20151106/jetty-io-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-io/9.3.6.v20151106/jetty-io-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-parent/25/jetty-parent-25.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-project/9.3.6.v20151106/jetty-project-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-security/9.3.6.v20151106/jetty-security-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-security/9.3.6.v20151106/jetty-security-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-server/9.3.6.v20151106/jetty-server-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-server/9.3.6.v20151106/jetty-server-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-servlet/9.3.6.v20151106/jetty-servlet-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-servlet/9.3.6.v20151106/jetty-servlet-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-util/9.3.6.v20151106/jetty-util-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-util/9.3.6.v20151106/jetty-util-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-webapp/9.3.6.v20151106/jetty-webapp-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-webapp/9.3.6.v20151106/jetty-webapp-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-xml/9.3.6.v20151106/jetty-xml-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/jetty-xml/9.3.6.v20151106/jetty-xml-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-api/9.3.6.v20151106/websocket-api-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-api/9.3.6.v20151106/websocket-api-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-client/9.3.6.v20151106/websocket-client-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-client/9.3.6.v20151106/websocket-client-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-common/9.3.6.v20151106/websocket-common-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-common/9.3.6.v20151106/websocket-common-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-parent/9.3.6.v20151106/websocket-parent-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-server/9.3.6.v20151106/websocket-server-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-server/9.3.6.v20151106/websocket-server-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-servlet/9.3.6.v20151106/websocket-servlet-9.3.6.v20151106.jar"
	"https://repo.maven.apache.org/maven2 org/eclipse/jetty/websocket/websocket-servlet/9.3.6.v20151106/websocket-servlet-9.3.6.v20151106.pom"
	"https://repo.maven.apache.org/maven2 org/fxmisc/easybind/easybind/1.0.3/easybind-1.0.3.jar"
	"https://repo.maven.apache.org/maven2 org/fxmisc/easybind/easybind/1.0.3/easybind-1.0.3.pom"
	"https://repo.maven.apache.org/maven2 org/hamcrest/hamcrest-core/1.3/hamcrest-core-1.3.jar"
	"https://repo.maven.apache.org/maven2 org/hamcrest/hamcrest-core/1.3/hamcrest-core-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/hamcrest/hamcrest-parent/1.3/hamcrest-parent-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/iq80/snappy/snappy/0.4/snappy-0.4.jar"
	"https://repo.maven.apache.org/maven2 org/iq80/snappy/snappy/0.4/snappy-0.4.pom"
	"https://repo.maven.apache.org/maven2 org/jdom/jdom/1.1.3/jdom-1.1.3.jar"
	"https://repo.maven.apache.org/maven2 org/jdom/jdom/1.1.3/jdom-1.1.3.pom"
	"https://repo.maven.apache.org/maven2 org/jetbrains/annotations/13.0/annotations-13.0.jar"
	"https://repo.maven.apache.org/maven2 org/jetbrains/annotations/13.0/annotations-13.0.pom"
	"https://repo.maven.apache.org/maven2 org/jetbrains/kotlin/kotlin-stdlib/1.1.51/kotlin-stdlib-1.1.51.jar"
	"https://repo.maven.apache.org/maven2 org/jetbrains/kotlin/kotlin-stdlib/1.1.51/kotlin-stdlib-1.1.51.pom"
	"https://repo.maven.apache.org/maven2 org/jetbrains/kotlin/kotlin-stdlib-jre7/1.1.51/kotlin-stdlib-jre7-1.1.51.jar"
	"https://repo.maven.apache.org/maven2 org/jetbrains/kotlin/kotlin-stdlib-jre7/1.1.51/kotlin-stdlib-jre7-1.1.51.pom"
	"https://repo.maven.apache.org/maven2 org/jetbrains/kotlin/kotlin-stdlib-jre8/1.1.51/kotlin-stdlib-jre8-1.1.51.jar"
	"https://repo.maven.apache.org/maven2 org/jetbrains/kotlin/kotlin-stdlib-jre8/1.1.51/kotlin-stdlib-jre8-1.1.51.pom"
	"https://repo.maven.apache.org/maven2 org/jmockit/jmockit/1.30/jmockit-1.30.jar"
	"https://repo.maven.apache.org/maven2 org/jmockit/jmockit/1.30/jmockit-1.30.pom"
	"https://repo.maven.apache.org/maven2 org/mockito/mockito-core/2.7.5/mockito-core-2.7.5.jar"
	"https://repo.maven.apache.org/maven2 org/mockito/mockito-core/2.7.5/mockito-core-2.7.5.pom"
	"https://repo.maven.apache.org/maven2 org/objenesis/objenesis/2.5/objenesis-2.5.jar"
	"https://repo.maven.apache.org/maven2 org/objenesis/objenesis/2.5/objenesis-2.5.pom"
	"https://repo.maven.apache.org/maven2 org/objenesis/objenesis/2.6/objenesis-2.6.pom"
	"https://repo.maven.apache.org/maven2 org/objenesis/objenesis-parent/2.5/objenesis-parent-2.5.pom"
	"https://repo.maven.apache.org/maven2 org/objenesis/objenesis-parent/2.6/objenesis-parent-2.6.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm/5.0.2/asm-5.0.2.jar"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm/5.0.2/asm-5.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm/6.0_BETA/asm-6.0_BETA.jar"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm/6.0_BETA/asm-6.0_BETA.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-analysis/6.0_BETA/asm-analysis-6.0_BETA.jar"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-analysis/6.0_BETA/asm-analysis-6.0_BETA.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-commons/6.0_BETA/asm-commons-6.0_BETA.jar"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-commons/6.0_BETA/asm-commons-6.0_BETA.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-parent/5.0.2/asm-parent-5.0.2.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-parent/6.0_BETA/asm-parent-6.0_BETA.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-tree/6.0_BETA/asm-tree-6.0_BETA.jar"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-tree/6.0_BETA/asm-tree-6.0_BETA.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-util/6.0_BETA/asm-util-6.0_BETA.jar"
	"https://repo.maven.apache.org/maven2 org/ow2/asm/asm-util/6.0_BETA/asm-util-6.0_BETA.pom"
	"https://repo.maven.apache.org/maven2 org/ow2/ow2/1.3/ow2-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/projectlombok/lombok/1.16.16/lombok-1.16.16.jar"
	"https://repo.maven.apache.org/maven2 org/projectlombok/lombok/1.16.16/lombok-1.16.16.pom"
	"https://repo.maven.apache.org/maven2 org/reactfx/reactfx/2.0-M3/reactfx-2.0-M3.jar"
	"https://repo.maven.apache.org/maven2 org/reactfx/reactfx/2.0-M3/reactfx-2.0-M3.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/jcl-over-slf4j/1.5.6/jcl-over-slf4j-1.5.6.jar"
	"https://repo.maven.apache.org/maven2 org/slf4j/jcl-over-slf4j/1.5.6/jcl-over-slf4j-1.5.6.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-api/1.5.6/slf4j-api-1.5.6.jar"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-api/1.5.6/slf4j-api-1.5.6.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-api/1.7.13/slf4j-api-1.7.13.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-api/1.7.22/slf4j-api-1.7.22.jar"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-api/1.7.22/slf4j-api-1.7.22.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-api/1.7.5/slf4j-api-1.7.5.jar"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-api/1.7.5/slf4j-api-1.7.5.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-jdk14/1.5.6/slf4j-jdk14-1.5.6.jar"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-jdk14/1.5.6/slf4j-jdk14-1.5.6.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-parent/1.5.6/slf4j-parent-1.5.6.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-parent/1.7.13/slf4j-parent-1.7.13.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-parent/1.7.22/slf4j-parent-1.7.22.pom"
	"https://repo.maven.apache.org/maven2 org/slf4j/slf4j-parent/1.7.5/slf4j-parent-1.7.5.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-api/1.7/aether-api-1.7.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-api/1.7/aether-api-1.7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-impl/1.7/aether-impl-1.7.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-impl/1.7/aether-impl-1.7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-parent/1.7/aether-parent-1.7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-spi/1.7/aether-spi-1.7.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-spi/1.7/aether-spi-1.7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-util/1.7/aether-util-1.7.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/aether/aether-util/1.7/aether-util-1.7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/forge/forge-parent/10/forge-parent-10.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/forge/forge-parent/3/forge-parent-3.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/forge/forge-parent/4/forge-parent-4.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/forge/forge-parent/5/forge-parent-5.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/forge/forge-parent/6/forge-parent-6.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/forge/forge-parent/7/forge-parent-7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/oss/oss-parent/7/oss-parent-7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/oss/oss-parent/9/oss-parent-9.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-build-api/0.0.4/plexus-build-api-0.0.4.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-build-api/0.0.4/plexus-build-api-0.0.4.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-build-api/0.0.7/plexus-build-api-0.0.7.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-build-api/0.0.7/plexus-build-api-0.0.7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-cipher/1.4/plexus-cipher-1.4.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-cipher/1.4/plexus-cipher-1.4.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-sec-dispatcher/1.3/plexus-sec-dispatcher-1.3.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/plexus/plexus-sec-dispatcher/1.3/plexus-sec-dispatcher-1.3.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/inject/guice-bean/1.4.2/guice-bean-1.4.2.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/inject/guice-bean/2.1.1/guice-bean-2.1.1.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/inject/guice-parent/2.9.4/guice-parent-2.9.4.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/inject/guice-plexus/1.4.2/guice-plexus-1.4.2.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/inject/guice-plexus/2.1.1/guice-plexus-2.1.1.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-guice/2.1.7/sisu-guice-2.1.7-noaop.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-guice/2.1.7/sisu-guice-2.1.7.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-guice/2.9.4/sisu-guice-2.9.4-no_aop.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-guice/2.9.4/sisu-guice-2.9.4.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject/1.4.2/sisu-inject-1.4.2.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject/2.1.1/sisu-inject-2.1.1.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-bean/1.4.2/sisu-inject-bean-1.4.2.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-bean/1.4.2/sisu-inject-bean-1.4.2.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-bean/2.1.1/sisu-inject-bean-2.1.1.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-bean/2.1.1/sisu-inject-bean-2.1.1.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-plexus/1.4.2/sisu-inject-plexus-1.4.2.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-plexus/1.4.2/sisu-inject-plexus-1.4.2.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-plexus/2.1.1/sisu-inject-plexus-2.1.1.jar"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-inject-plexus/2.1.1/sisu-inject-plexus-2.1.1.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-parent/1.4.2/sisu-parent-1.4.2.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/sisu/sisu-parent/2.1.1/sisu-parent-2.1.1.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/spice/spice-parent/10/spice-parent-10.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/spice/spice-parent/12/spice-parent-12.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/spice/spice-parent/15/spice-parent-15.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/spice/spice-parent/16/spice-parent-16.pom"
	"https://repo.maven.apache.org/maven2 org/sonatype/spice/spice-parent/17/spice-parent-17.pom"
	"https://repo.maven.apache.org/maven2 org/springframework/spring-core/4.1.1.RELEASE/spring-core-4.1.1.RELEASE.jar"
	"https://repo.maven.apache.org/maven2 org/springframework/spring-core/4.3.6.RELEASE/spring-core-4.3.6.RELEASE.jar"
	"https://repo.maven.apache.org/maven2 org/springframework/spring-core/4.3.6.RELEASE/spring-core-4.3.6.RELEASE.pom"
	"https://repo.maven.apache.org/maven2 org/springframework/spring-test/4.1.1.RELEASE/spring-test-4.1.1.RELEASE.jar"
	"https://repo.maven.apache.org/maven2 org/springframework/spring-test/4.3.6.RELEASE/spring-test-4.3.6.RELEASE.jar"
	"https://repo.maven.apache.org/maven2 org/springframework/spring-test/4.3.6.RELEASE/spring-test-4.3.6.RELEASE.pom"
	"https://repo.maven.apache.org/maven2 org/tukaani/xz/1.5/xz-1.5.jar"
	"https://repo.maven.apache.org/maven2 org/tukaani/xz/1.5/xz-1.5.pom"
	"https://repo.maven.apache.org/maven2 org/tukaani/xz/1.6/xz-1.6.jar"
	"https://repo.maven.apache.org/maven2 org/tukaani/xz/1.6/xz-1.6.pom"
	"https://repo.maven.apache.org/maven2 org/vafer/jdependency/1.2/jdependency-1.2.jar"
	"https://repo.maven.apache.org/maven2 org/vafer/jdependency/1.2/jdependency-1.2.pom"
	"https://repo.maven.apache.org/maven2 org/xolstice/maven/plugins/protobuf-maven-plugin/0.5.0/protobuf-maven-plugin-0.5.0.jar"
	"https://repo.maven.apache.org/maven2 org/xolstice/maven/plugins/protobuf-maven-plugin/0.5.0/protobuf-maven-plugin-0.5.0.pom"
	"https://repo.maven.apache.org/maven2 oro/oro/2.0.8/oro-2.0.8.jar"
	"https://repo.maven.apache.org/maven2 oro/oro/2.0.8/oro-2.0.8.pom"
	"https://repo.maven.apache.org/maven2 sslext/sslext/1.2-0/sslext-1.2-0.jar"
	"https://repo.maven.apache.org/maven2 sslext/sslext/1.2-0/sslext-1.2-0.pom"
	"https://repo.maven.apache.org/maven2 uk/co/froot/maven/enforcer/digest-enforcer-parent/0.0.1/digest-enforcer-parent-0.0.1.pom"
	"https://repo.maven.apache.org/maven2 uk/co/froot/maven/enforcer/digest-enforcer-rules/0.0.1/digest-enforcer-rules-0.0.1.jar"
	"https://repo.maven.apache.org/maven2 uk/co/froot/maven/enforcer/digest-enforcer-rules/0.0.1/digest-enforcer-rules-0.0.1.pom"
	"https://repo.maven.apache.org/maven2 xerces/xercesImpl/2.9.1/xercesImpl-2.9.1.jar"
	"https://repo.maven.apache.org/maven2 xerces/xercesImpl/2.9.1/xercesImpl-2.9.1.pom"
	"https://repo.maven.apache.org/maven2 xml-apis/xml-apis/1.0.b2/xml-apis-1.0.b2.pom"
	"https://repo.maven.apache.org/maven2 xml-apis/xml-apis/1.3.04/xml-apis-1.3.04.jar"
	"https://repo.maven.apache.org/maven2 xml-apis/xml-apis/1.3.04/xml-apis-1.3.04.pom"
)

__set_vendor_uri() {
	local lib
	for lib in "${EMAVEN_VENDOR[@]}"; do
		SRC_URI+=" ${lib%% *}/${lib##* }"
	done
}

__set_vendor_uri
unset -f __set_vendor_uri

pkg_setup() {
	java-pkg_init
}

src_unpack() {
	unpack "${P}.tar.gz"
	local d f maven_basedir="${T}/m2"
	mkdir -p "${maven_basedir}" || die
	for f in "${EMAVEN_VENDOR[@]}"; do
		f=${f##* }
		d=${f%/*}
		f=${f##*/}
		mkdir -p "${maven_basedir}"/"${d}" || die
		cp "${DISTDIR}/${f}" "${maven_basedir}/${d}/" || die
	done
}

src_prepare() {
	sed -e 's:/path/to/local/repo:'${T}/m2':g' -e 's:<!-- localRepo::' < \
		"${EPREFIX}/usr/share/$(readlink "${EPREFIX}/usr/bin/mvn" |
		sed 's:mvn:maven-bin:')/conf/settings.xml" > "${S}"/settings.xml || \
			die "failed to create settings.xml"
	default
}

src_compile() {
	mvn -s "${S}"/settings.xml --offline \
		package verify -DskipTests -Dmaven.javadoc.skip=true || die
}

src_install() {
	local x
	# The following command is derived from package/linux/64bitBuild.sh.
	mkdir -p gui/deploy || die
		"${JAVA_HOME}/bin/javapackager" \
		-deploy \
		-Bruntime="${JAVA_HOME}/jre" \
		-BappVersion=$version \
		-Bcategory=Network \
		-Bemail=contact@bisq.network \
		-BlicenseType=GPLv3 \
		-BlicenseFile=LICENSE \
		-Bicon=package/linux/icon.png \
		-native image \
		-name Bisq \
		-title Bisq \
		-vendor Bisq \
		-outdir gui/deploy \
		-srcfiles "gui/target/shaded.jar" \
		-srcfiles "gui/target/lib/bcpg-jdk15on.jar" \
		-srcfiles "gui/target/lib/bcprov-jdk15on.jar" \
		-srcfiles package/linux/LICENSE \
		-appclass io.bisq.gui.app.BisqAppMain \
		-BjvmOptions=-Xss1280k \
		-outfile Bisq || die

	# This procedure is derived from doc/install_on_unix*.sh:
	printf "security.provider.10=org.bouncycastle.jce.provider.BouncyCastleProvider\n" >> \
		gui/deploy/bundles/Bisq/runtime/lib/security/java.security || die
	# Also include bcpg-jdk15on.jar here due to
	# https://github.com/bisq-network/exchange/issues/1067
	# It may be related to org.bouncycastle excludes in the
	# pom files, see 80aca142ffa1e8a34df25b7489ca2685d29dbdc4.
	for x in bcprov-jdk15on.jar bcpg-jdk15on.jar; do
		ln gui/deploy/bundles/Bisq/app/${x} gui/deploy/bundles/Bisq/runtime/lib/ext/${x} || die
	done

	dodir /opt
	mv gui/deploy/bundles/Bisq "${ED}/opt/Bisq" || die

	newicon package/linux/icon.png bisq.png
	dosym ../../opt/Bisq/Bisq /usr/bin/bisq
	make_desktop_entry bisq Bisq bisq "Finance;Network"
}

pkg_postinst() {
	xdg_desktop_database_update
}

pkg_postrm() {
	xdg_desktop_database_update
}
