# Copyright 1999-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5

inherit eutils autotools

DESCRIPTION="File system for accessing ftp hosts based on FUSE"
HOMEPAGE="http://curlftpfs.sourceforge.net/"
SRC_URI="mirror://sourceforge/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 arm ~arm64 x86 ~amd64-linux ~x86-linux ~x86-macos"
IUSE=""
RESTRICT="test" # bug 258460

RDEPEND=">=net-misc/curl-7.17.0
	>=sys-fs/fuse-2.2
	>=dev-libs/glib-2.0"
DEPEND="${RDEPEND}
	virtual/pkgconfig"

src_prepare() {
	epatch "${FILESDIR}"/${P}-64bit_filesize.patch
	epatch "${FILESDIR}"/${PN}-0.9.2-darwin.patch
	epatch "${FILESDIR}"/${PN}-0.9.2-memleak.patch
	epatch "${FILESDIR}"/${PN}-0.9.2-memleak-nocache.patch
	epatch "${FILESDIR}"/${PN}-0.9.2-fix-escaping.patch

	# automake-1.13.1 obsoletes AM_* bit #469818
	sed -i -e 's/AM_CONFIG_HEADER/AC_CONFIG_HEADERS/' configure.ac || die

	epatch_user

	eautoreconf
}

src_install() {
	default
	dodoc README
}
