# Copyright 1999-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

PYTHON_COMPAT=( python{3_4,3_5,3_6} )

inherit gnome2-utils python-single-r1

DESCRIPTION="Actions gestures on your touchpad using libinput"
HOMEPAGE="https://github.com/bulletmark/libinput-gestures"
if [[ ${PV} == *9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/bulletmark/${PN}.git"
else
	SRC_URI="https://github.com/bulletmark/${PN}/archive/${PV}.tar.gz -> ${P}.tar.gz"
	KEYWORDS="~amd64 ~x86"
fi

LICENSE="GPL-3"
SLOT="0"
IUSE="test"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

RDEPEND="${PYTHON_DEPS}
	>=dev-libs/libinput-1.8.0
	x11-misc/xdotool
	x11-misc/wmctrl"
DEPEND=">=dev-libs/libinput-1.8.0
	dev-util/desktop-file-utils
	test? ( dev-python/flake8[${PYTHON_USEDEP}] )"

src_prepare() {
	default

	# Fix docdir installation path
	sed '/^DOCDIR/s@$NAME@${PF}@' -i libinput-gestures-setup || die
}

pkg_postinst() {
	gnome2_icon_cache_update

	elog "You must be in the input group to read the touchpad device."

	if ! has_version x11-libs/gtk+:3 ; then
		elog "${PN}-setup script supports Gnome 3 via x11-libs/gtk+:3."
	fi
	if ! has_version kde-plasma/kde-cli-tools:5 ; then
		elog "${PN}-setup script supports Plasma 5 via kde-plasma/kde-cli-tools:5."
	fi
}

pkg_postrm() {
	gnome2_icon_cache_update
}
