# Copyright 1999-2018 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5

inherit autotools-multilib

DESCRIPTION="reference implementation of the net-color spec"
HOMEPAGE="http://www.oyranos.org/libxcm/"
SRC_URI="mirror://sourceforge/oyranos/${PN}/${PN}-0.4.x/${P}.tar.bz2"

LICENSE="MIT"
SLOT="0"
KEYWORDS="amd64 ppc x86"
IUSE="X static-libs"

RDEPEND="X? (
		>=x11-libs/libXmu-1.1.1-r1[${MULTILIB_USEDEP}]
		>=x11-libs/libXfixes-5.0.1[${MULTILIB_USEDEP}]
		>=x11-libs/libX11-1.6.2[${MULTILIB_USEDEP}] )"
DEPEND="${RDEPEND}
	x11-base/xorg-proto"

src_configure() {
	local myeconfargs=(
		--disable-silent-rules
		$(use_with X x11)
		$(use_enable static-libs static)
	)
	autotools-multilib_src_configure
}
