# Copyright 2010-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=5

BITCOINCORE_COMMITHASH="03422e564b552c1d3c16ae854f8471f7cb39e25d"
BITCOINCORE_LJR_DATE="20161027"
BITCOINCORE_IUSE="+ljr"
inherit bash-completion-r1 bitcoincore

DESCRIPTION="Command-line JSON-RPC client for the communication with the Bitcoin Core Daemon"
LICENSE="MIT"
SLOT="0"
KEYWORDS="amd64 arm ~arm64 ~mips ~ppc x86 ~amd64-linux ~x86-linux"

src_prepare() {
	sed -i 's/have bitcoind &&//;s/^\(complete -F _bitcoind \)bitcoind \(bitcoin-cli\)$/\1\2/' contrib/bitcoind.bash-completion || die
	bitcoincore_src_prepare
}

src_configure() {
	bitcoincore_conf \
		--enable-util-cli
}

src_install() {
	bitcoincore_src_install

	doman contrib/debian/manpages/bitcoin-cli.1

	newbashcomp contrib/bitcoind.bash-completion ${PN}
}
