# Copyright 1999-2017 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

MY_P="${PN/-}-${PV}"

DESCRIPTION="daemon to proxy GSSAPI context establishment and channel handling"
HOMEPAGE="https://pagure.io/gssproxy"
SRC_URI="http://releases.pagure.org/gssproxy/${MY_P}.tar.gz"

LICENSE="BSD-1"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~arm ~arm64 ~hppa ~ia64 ~mips ~ppc ~ppc64 ~s390 ~sh ~sparc ~x86"
IUSE="debug selinux systemd hardened"

RDEPEND=">=dev-libs/libverto-0.2.2
	>=dev-libs/ding-libs-0.5.0
	virtual/krb5
	selinux? ( sys-libs/libselinux )"
# We need xml stuff to build the man pages, and people really want/need
# the man pages for this package :). #585200
DEPEND="${RDEPEND}
	app-text/docbook-xml-dtd:4.4
	dev-libs/libxslt
	virtual/pkgconfig"

S="${WORKDIR}/${MY_P}"

# Many requirements to run tests, including running slapd as root, hence
# unfeasible.
RESTRICT="test"

# pkg_setup() {
# 	# Here instead of flag-logic in DEPEND, since virtual/krb5 does not
# 	# allow to specify the openldap use flag, which heimdal doesn't
# 	# support.
# 	# Using mit-krb5 explicitly because heimdal doesn't install kerberos
# 	# schemata required for the tests of gss-proxy.
# 	if use test && ! has_version "app-crypt/mit-krb5[openldap]"; then
# 		eerror "Tests of this package require the kerberos schemata installed from app-crypt/mit-krb5[openldap]."
# 		die "Tests enabled but no app-crypt/mit-krb5[openldap] being installed."
# 	fi
# }

# Was required in 0.7.0 to fix the schema- and slapd-path. Reason for
# comment: see RESTRICT comment
# src_prepare() {
# 	default
# 	# The tests look for kerberos schemata in the documentation
# 	# directory of krb5, however these are installed in /etc/openldap
# 	# and only if the openldap useflag is supplied
# 	sed -i \
# 		-e 's#/usr/share/doc/krb5-server-ldap*#/etc/openldap/schema#' \
# 		-e "s#\(subprocess.Popen..\"\)slapd#\1/usr/$(get_libdir)/openldap/slapd#" \
# 		"${S}/tests/testlib.py" || die
# }

src_configure() {
	local myeconfargs=(
		# The build assumes localstatedir is /var and takes care of
		# using all the right subdirs itself.
		"--localstatedir=${EPREFIX}/var"
		"--with-os=gentoo"
		"--with-initscript=$(usex systemd systemd none)"
		"$(use_with selinux)"
		"$(use_with debug gssidebug)"
		"$(use_with hardened hardening)"
	)

	econf "${myeconfargs[@]}"
}

src_install() {
	default
	# This is a plugin module, so no need for la file.
	find "${ED%/}"/usr -name proxymech.la -delete

	doinitd "${FILESDIR}"/gssproxy
	insinto /etc/gssproxy
	doins examples/*.conf
	insinto /etc/gss/mech.d
	newins examples/mech gssproxy.conf

	# The build installs a bunch of empty dirs, so prune them.
	find "${ED}" -depth -type d -exec rmdir {} + 2>/dev/null
}
