.\" Roff format skeleton provided by Taketo Kabe <kabe@sra-tohoku.co.jp>
.TH stone 1 "version 2.3"
.
.SH NAME
stone \- Simple Repeater
.
.SH SYNOPSIS
.B "stone [-C \fIfile\fP] [-P \fIcommand\fP] [-Q \fIoptions\fP] [-N] [-d] [-p] [-n]"
.br
.B "      [-u \fImax\fP] [-f \fIn\fP] [-l] [-L \fIfile\fP] [-a \fIfile\fP] [-i \fIfile\fP]"
.br
.B "      [-X \fIn\fP] [-T \fIn\fP] [-r]"
.br
.B "      [-x \fIport\fP[,\fIport\fP][-\fIport\fP]... \fIxhost\fP... --]"
.br
.B "      [-s \fIsend\fP \fIexpect\fP... --]"
.br
.B "      [-b [\fIvar\fP=\fIval\fP]... \fIn\fP \fImaster\fP:\fIport\fP \fIbackup\fP:\fIport\fP]"
.br
.B "      [-B \fIhost\fP:\fIport\fP \fIhost1\fP:\fIport1\fP... --]"
.br
.B "      [-I \fIhost\fP]"
.br
.B "      [-o \fIn\fP] [-g \fIn\fP] [-t \fIdir\fP] [-D] [-c \fIdir\fP]"
.br
.B "      [-q \fISSL\fP] [-z \fISSL\fP]"
.br
.B "      [-M install \fIname\fP] [-M remove \fIname\fP]"
.br
.B "      \fIst\fP [-- \fIst\fP]..."
.
.SH DESCRIPTION
\fBStone\fP is a TCP & UDP repeater in the application layer.  It repeats TCP
and UDP from inside to outside of a firewall, or from outside to inside.
.P
\fBStone\fP has following features:
.
.TP
.B 1. Stone supports Win32.
Formerly, UNIX machines are used as firewalls, but recently
WindowsNT machines are used, too.  You can easily run \fBstone\fP on
WindowsNT and Windows95.  Of course, available on Linux,
FreeBSD, BSD/OS, SunOS, Solaris, HP-UX and so on.
.
.TP
.B 2. Simple.
\fBStone\fP's source code is only 8000 lines long (written in C
language), so you can minimize the risk of security
holes.
.
.TP
.B 3. Stone supports SSL.
Using OpenSSL (\fIhttp://www.openssl.org/\fP), \fBstone\fP can
encrypt/decrypt.  Client verifications, and server verifications
are also supported.  \fBStone\fP can send a substring of the subject
of the certificate to the destination.
.
.TP
.B 4. Stone is a http proxy.
\fBStone\fP can also be a tiny http proxy.
.
.TP
.B 5. POP -> APOP conversion.
With \fBstone\fP and a mailer that does not support APOP, you can
access to an APOP server.
.
.TP
.B 6. Stone supports IPv6.
\fBStone\fP can convert IP and IPv6 each other.  With \fBstone\fP, you can
use IP-only software on IPv6 network.
.
.SH OPTIONS
If the \fB-C\fP \fIfile\fP flag is used, the program read these
options and \fIst\fPs from the configuration file \fIfile\fP.
If the \fB-P\fP \fIcommand\fP flag is used, the program executes
specified pre-processor to read the configuration file.  \fB-Q\fP \fIoptions\fP
can be used to pass options to the pre-processor.  If the \fB-N\fP
flag is used, \fBstone\fP will terminate after parsing options
and configuration file without opening the ports.
.P
If the \fB-d\fP flag is used, then increase the debug level.  If
the \fB-p\fP flag is used, data repeated by \fBstone\fP are dumped.  If
the \fB-n\fP is used, IP addresses and service port numbers are
shown instead of host names and service names.
.P
If the \fB-u\fP \fImax\fP flag (\fImax\fP is integer) is used, the
program memorize \fImax\fP UDP sources simultaneously.  The default value
is 100. If the
\fB-f\fP \fIn\fP flag (\fIn\fP is integer) is used, the program spawn
\fIn\fP child processes. The default behavior is not to spawn any child processes.
.P
If the \fB-l\fP flag is used, the program sends error messages to
the syslog instead of stderr.  If the \fB-L\fP \fIfile\fP (\fIfile\fP
is a file name) flag is used, the program writes error messages
to the file.  If the \fB-a\fP \fIfile\fP flag is used, the program
writes accounting to the file.  If the \fB-i\fP \fIfile\fP flag is
used, the program writes its process ID to the file.
.P
The \fB-X\fP \fIn\fP flag alters the buffer size of the repeater.
The default value is 1000 bytes. If
the \fB-T\fP \fIn\fP is used, the timeout of TCP sessions can be
specified to \fIn\fP sec.  Default: 600 (10 min).  The \fB-r\fP flag is
used, SO_REUSEADDR is set on the socket of \fIst\fP .
.P
Using the \fB-x\fP \fIport\fP[,\fIport\fP][-\fIport\fP]... \fIxhost\fP... \fB--\FP flag,
the http proxy (described later) can only connect to
\fIxhost\fP:\fIport\fP.  If more than one \fB-x\fP ... \fB--\fI flags are
designated, the posterior one whose \fIport\fP list matches the
connecting port.  If the \fB-x\fP \fB--\fP is used, prior \fB-x\fP flags
are ignored.
.P
The \fB-b\fP \fIn\fP \fImaster\fP:\fIport\fP \fIbackup\fP:\fIport\fP flag designates
the backup destination for \fImaster\fP:\fIport\fP.  The program checks
every \fIn\fP seconds whether \fImaster\fP:\fIport\fP is connectable, using
the health check script defined by \fB-s\fP flag described below.
If not, the backup is used instead.  Alternative \fIhost\fP can be
checked, using host=\fIhost\fP and alternative \fIport\fP, using
port=\fIport\fP.
.P
The \fB-s\fP \fIsend\fP \fIexpect\fP... \fB--\fP flag defines the health check
script.  Sending \fIsend\fP, then checks whether the response match
the regular expression \fIexpect\fP.
.P
The \fB-B\fP \fIhost\fP:\fIport\fP \fIhost1\fP:\fIport1\fP... \fB--\fP is for the
destination group.  If the destination of \fIst\fP is \fIhost\fP:\fIport\fP,
the program chooses a destination randomly from the group.  The
destination \fIhost\fP:\fIport\fP that is designated by \fB-b\fP flag and
turned out unhealthy, is excluded from the group.
.P
The \fB-I\fP \fIhost\fP designates the interface used as the source
address of the connection to the desctination.
.P
If the \fB-o\fP \fIn\fP or \fB-g\fP \fIn\fP flag is used, the program set
its uid or gid to \fIn\fP respectively.  If the \fB-t\fP \fIdir\fP
flag (\fIdir\fP is a directory) is used, the program change its
root to the directory.  If the \fB-D\fP flas is used, \fBstone\fP runs
as a daemon. The \fB-c\fP \fIdir\fP flag designates the
directory for core dump.
.P
The \fB-M\fP install \fIname\fP and the \fB-M\fP remove \fIname\fP flags are
for NT service.  \fIname\fP is the service name.  Start the
service using the command: net start \fIname\fP.  To install \fBstone\fP
service as the name \fIrepeater\fP, for example:
.P
.RS
C:\\>\fBstone -M install \fIrepeater\fB -C \fIC:\\stone.cfg\fR
.br
C:\\>\fBnet start \fIrepeater\fR
.RE
.P
The \fB-q\fP \FISSL\FP and the \fB-z\fP \FISSL\FP flags are for SSL
encryption.  The \fB-q\fP \FISSL\FP is for the client mode, that is,
when \fBstone\fP connects to the other SSL server as a SSL client.
The \fB-z\fP \FISSL\FP if for the server mode, that is, when other SSL
clients connect to the \fBstone\fP.
.P
\FISSL\FP is one of the following.
.P
.PD 0
.IP default 15
reset SSL options to the default.
Using multiple \fIst\fP, different SSL options can
be designated for each \fIst\fP.
.IP verbose
verbose mode.
.IP verify
require SSL certificate to the peer.
.IP verify,once
request a client certificate on the initial TLS/SSL
handshake. (\fB-z\fP only)
.IP verify,ifany
The certificate returned (if any) is checked. (\fB-z\fP only)
.IP verify,none
never request SSL certificate to the peer.
.IP crl_check
lookup CRLs.
.IP crl_check_all
lookup CRLs for whole chain.
.IP uniq
if the serial number of peer's SSL certificate
is different from the previous session, deny it.
.IP re\fIn\fP=\fIregex\fP
The certificate of the peer must satisfy the
\fIregex\fP.  \fIn\fP is the depth.  re0 means the subject
of the certificate, and re1 means the issure.
The maximum of \fIn\fP is 9.
.IP depth=\fIn\fP
The maximum of the certificate chain.
If the peer's certificate exceeds \fIn\fP, the
verification fails.  The maximum of \fIn\fP is 9.
.IP tls1
Just use TLSv1 protocol.
.IP ssl3
Just use SSLv3 protocol.
.IP ssl2
Just use SSLv2 protocol.
.IP no_tls1
Turn off TLSv1 protocol.
.IP no_ssl3
Turn off SSLv3 protocol.
.IP no_ssl2
Turn off SSLv2 protocol.
.IP bugs
Switch on all SSL implementation bug workarounds.
.IP serverpref
Use server's cipher preferences (only SSLv2).
.IP sid_ctx=\fIstr\fP
Set session ID context.
.IP passfile=\fIfile\fP
The filename of the file containing password of the key
.IP key=\fIfile\fP
The filename of the secret key of the certificate.
.IP cert=\fIfile\fP
The filename of the certificate.
.IP CAfile=\fIfile\fP
The filename of the certificate of the CA.
.IP CApath=\fIdir\fP
The directory of the certificate files.
.IP pfx=\fIfile\fP
The filename of the PKCS#12 bag.
.IP cipher=\fIlist\fP
The list of ciphers.
.IP lb\fIn\fP=\fIm\fP
change the destination according to the
certificate of the peer.  The number calculated
from the matched string to the \fIn\fPth ( ... ) in
the ``regex'' of SSL options (mod \fIm\fP) is used
to select the destination from the destination
group defined by \fB-B\fP flag.
.PD
.P
\fIst\fP is one of the following.  Multiple \fIst\fP can be
designated, separated by \fB--\fP.
.P
.PD 0
.IP (1)
\fIhost\fP:\fIport\fP \fIsport\fP [\fIxhost\fP...]
.IP (2)
\fIhost\fP:\fIport\fP \fIshost\fP:\fIsport\fP [\fIxhost\fP...]
.IP (3)
proxy \fIsport\fP [\fIxhost\fP...]
.IP (4)
\fIhost\fP:\fIport\fP/http \fIrequest\fP [\fIxhost\fP...]
.IP (5)
\fIhost\fP:\fIport\fP/proxy \fIheader\fP [\fIxhost\fP...]
.IP (6)
health \fIsport\fP [\fIxhost\fP...]
.PD
.P
The program repeats the connection on port \fIsport\fP to the
other machine \fIhost\fP port \fIport\fP.  If the machine, on
which the program runs, has two or more interfaces, type (2) can
be used to repeat the connection on the specified interface
\fIshost\fP.  You can also specify path name that begins with
``/'' or ``./'', instead of \fIhost\fP:\fIport\fP so that the
program handles a unix domain socket.
.P
Type (3) is a http proxy.  Specify the machine, on which the
program runs, and port \fIsport\fP in the http proxy settings of
your WWW browser.
Extentions can be added to the ``proxy'' like \fIxhost\fP/\fIext\fP.
\fIext\fP is:
.P
.IP v4only
limit the destination within IP addresses.
.IP v6only
limit the destination within IPv6 addresses.
.P
Type (4) relays stream over http request.  \fIrequest\fP is the
request specified in HTTP 1.0.  In the \fIrequest\fP, \ is
the escape character, and the following substitution occurs.
.PP
.RS 8
.PD 0
.IP \\\\n 8
newline  (0x0A)
.IP \\\\r
return   (0x0D)
.IP \\\\t
tab      (0x09)
.IP \\\\\\\\
\ itself (0x5C)
.IP \\\\a
the IP address of the client connecting to the \fBstone\fP.
.IP \\\\A
\fIIP address of the client\fP:\fIport number\fP
.IP \\\\0
the serial number of peer's SSL certificate.
.IP "\\\\1 - \\\\9"
the matched string in the ``regex'' of SSL options.
.IP \\\\?1\fIthen\fP\\\\:\fIelse\fP\\\\/
if \1 (\2 - \9 in a similar way) is not null,
\fIthen\fP, otherwise \fIelse\fP.
.PD
.RE
.P
Type (5) repeats http request with \fIheader\fP in the top of
request headers.  The above escapes can be also used.
.P
Type (6) designates the port that other programs can check
whether the \fBstone\fP runs `healthy' or not.  Following commands are
available to check the \fBstone\fP.
.P
.RS 8
.PD 0
.IP "HELO \fIany string\fP" 24
returns the status of the \fBstone\fP
.IP "LIMIT \fIvar\fP \fIn\fP"
check the value of \fIvar\fP is
less than \fIn\fP
.PD
.RE
.P
\fIvar\fP is one of the following:
.P
.RS 8
.PD 0
.IP PAIR 16
the number of ``pair''
.IP CONN
the number of ``conn''
.IP ESTABLISHED
seconds passed since the last conn established
.IP READWRITE
seconds passed since the last read/write
.IP ASYNC
the number of threads
.PD
.RE
.P
The response of the \fBstone\fP is 2xx when normal, or 5xx when
abnormal on the top of line.
.P
If the \fIxhost\fP are used, only machines or its IP addresses
listed in \fIxhost\fP separated by space character can
connect to the program and to be repeated.
.P
Extentions can be added to the \fIxhost\fP like
\fIxhost\fP/\fIex\fP,\fIex\fP....  \fIex\fP is:
.IP \fIm\fP
You can designate the length of prefix bits of the
netmask, so that only machines on specified.  In the
case of class C network 192.168.1.0, for example, use
``192.168.1.0/24''.
.IP v4
\fIxhost\fP is resolved as the IP address.
.IP v6
\fIxhost\fP is resolved as the IPv6 address.
.IP p\fIm\fP
the data repeated by the program are dumped, only if it
was connected by the machines specified by \fIxhost\fP.  \fIm\fP
is the dump mode, equivalent to the number of \fB-p\fP
options.
.P
Use ``!'' instead of ``\fIxhost\fP'', to deny machines by following
\fIxhost\fP.
.P
Extentions can be added to the \fIport\fP like
\fIport\fP/\fIext\fP,\fIext\fP....  \fIext\fP is:
.IP udp
repeats UDP instead of TCP.
.IP ssl
forwards with encryption.
.IP v6
connects to the destination using IPv6.
.IP base
forwards with MIME base64 encoding.
.P
Extentions can be added to the \fIsport\fP like
\fIsport\fP/\fIext\fP,\fIext\fP....  \fIext\fP is:
.IP udp
repeats UDP instead of TCP.
.IP apop
converts POP to APOP.  The conversion is derived from
the RSA Data Security, Inc. MD5 Message-Digest Algorithm.
.IP ssl
forwards with decryption.
.IP v6
accepts connection using IPv6.  If \fIshost\fP is omitted
like (1), IP is also acceptable.
.IP v6only
accepts connection using IPv6 only.  Even if \fIshost\fP is
omitted like (1), IP is not acceptable.
.IP base
forwards with MIME base64 decoding.
.IP http
relays stream over http.
.IP ident
identifies the owner of the incoming connection
on the peer using ident protocol (RFC1413).
.SH EXAMPLES
.PD 0
.IP \fIouter\fP\^:
a machine in the outside of the firewall
.IP \fIinner\fP\^:
a machine in the inside of the firewall
.IP \fIfwall\fP\^:
the firewall on which the \fBstone\fP is executed
.PD
.TP
\fBstone \fIouter\fB:telnet 10023\fR
Repeats the telnet protocol to \fIouter\fP.
Run telnet fwall 10023 on \fIinner\fR.
.TP
\fBstone \fIouter\fB:domain/udp domain/udp\fR
Repeats the DNS query to \fIouter\fP.
Run \fBnslookup -\fP \fIfwall\fP on \fIinner\fP.
.TP
\fBstone \fIouter\fB:ntp/udp ntp/udp\fR
Repeats the NTP to \fIouter\fP.
Run \fBntpdate \fIfwall\fR on \fIinner\fP.
.TP
\fBstone localhost:http 443/ssl\fR
Make WWW server that supports https.
Access \fBhttps://\fIfwall\fB/\fR using a WWW browser.
.TP
\fBstone localhost:telnet 10023/ssl\fR
Make telnet server that supports SSL.
Run \fBSSLtelnet -z ssl \fIfwall\fB 10023\fR on \fIinner\fP.
.TP
\fBstone proxy 8080\fR
http proxy
.TP
\fBstone\fP \fIouter\fB:110/apop 110\fR
connect to \fIinner\fP:pop using a mailer that does not
support APOP.
.PP
Where \fIfwall\fP is a http proxy (port 8080):
.TP
\fBstone \fIfwall\fB:8080/http 10023 'POST http://\fIouter\fB:8023 HTTP/1.0'\fR
.br
.ns
.TP
\fBstone localhost:telnet 8023/http
.nf
Run \fBstone\fPs on \fIinner\fP and \fIouter\fP respectively.
Relays stream over http.
.TP
\fBstone \fIfwall\fB:8080/proxy 9080 \'Proxy-Authorization: Basic \fIc2VuZ29rdTpoaXJvYWtp\fB\'\fR
for browser that does not support proxy authorization.
.fi
.
.SH HOMEPAGE
The official homepage of \fBstone\fP is:
.br
\fIhttp://www.gcd.org/sengoku/stone/\fP
.
.SH COPYRIGHT
All rights about this program \fBstone\fP are reserved by the
original author, Hiroaki Sengoku.  The program is free software;
you can redistribute it and/or modify it under the terms of the
\fIGNU IGeneral Public License (GPL)\fP.  Furthermore you can link it
with openssl.
.
.SH NO WARRANTY
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.
.
.SH AUTHOR
.nf
Hiroaki Sengoku
sengoku@gcd.org
http://www.gcd.org/sengoku/
.fi
