# Copyright 1999-2016 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2

EAPI=6

inherit qmake-utils

MY_P="${P/_beta/beta}"
DESCRIPTION="A multi-platform helper library for other libraries"
HOMEPAGE="http://www.aquamaniac.de/aqbanking/"
SRC_URI="http://www.aquamaniac.de/sites/download/download.php?package=01&release=201&file=01&dummy=${MY_P}.tar.gz -> ${MY_P}.tar.gz"
S="${WORKDIR}/${MY_P}"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="~amd64 ~hppa ~ppc ~ppc64 ~sparc ~x86"
IUSE="debug doc fox gtk qt4 qt5"

RDEPEND="dev-libs/libgpg-error
	dev-libs/libgcrypt:0=
	dev-libs/openssl:0=
	net-libs/gnutls:=
	virtual/libiconv
	virtual/libintl
	fox? ( x11-libs/fox:1.6 )
	gtk? ( x11-libs/gtk+:2 )
	qt4? ( dev-qt/qtgui:4 )
	qt5? ( dev-qt/qtgui:5 )"
DEPEND="${RDEPEND}
	virtual/pkgconfig
	sys-devel/gettext
	doc? ( app-doc/doxygen )"

# broken upstream, reported but got no reply
RESTRICT="test"

src_configure() {
	local guis
	local extra_opts
	use fox && guis="${guis} fox16"
	use gtk && guis="${guis} gtk2"
	use qt4 && guis="${guis} qt4" && extra_opts="${extra_opts} --with-qt4-moc="$(qt4_get_bindir)/moc""
	use qt5 && guis="${guis} qt5" && extra_opts="${extra_opts} --with-qt5-qmake="$(qt5_get_bindir)/qmake" --with-qt5-moc="$(qt5_get_bindir)/moc""
	econf \
		--enable-ssl \
		$(use_enable debug) \
		$(use_enable doc full-doc) \
		--with-guis="${guis}" \
		${extra_opts} \
		--with-docpath="${EPREFIX}/usr/share/doc/${PF}/apidoc"
}

src_compile() {
	emake
	use doc && emake srcdoc
}

src_install() {
	default
	use doc && emake DESTDIR="${D}" install-srcdoc
	find "${ED}" -name '*.la' -delete || die
}
